package editor;

import game.IntRect;

import java.awt.Color;
import java.awt.Graphics;

public abstract class ScreenObject {
	
	public abstract void draw(Graphics g);
	
	public abstract IntRect getClickRect();
	public abstract void setClickRect(IntRect newRect);
	
	public abstract void setSelected(boolean is);
	public abstract boolean isSelected();
	
	public abstract int getLayer();
	
	public void drawSelectionOverObject(Graphics g) {
		
		IntRect rect = getClickRect();
		
		Color origColor = g.getColor();
		
		g.setColor(Color.black);
		
		g.drawRect(rect.getMinX(), rect.getMinY(), rect.width(), rect.height());
		
		g.setColor(Color.white);
		g.fillOval(rect.getMinX() - 5, rect.getMinY() - 5, 11, 11);
		g.fillOval(rect.getMinX() - 5, rect.getMaxY() - 5, 11, 11);
		g.fillOval(rect.getMaxX() - 5, rect.getMaxY() - 5, 11, 11);
		g.fillOval(rect.getMaxX() - 5, rect.getMinY() - 5, 11, 11);
		
		g.setColor(Color.black);
		g.drawOval(rect.getMinX() - 5, rect.getMinY() - 5, 11, 11);
		g.drawOval(rect.getMinX() - 5, rect.getMaxY() - 5, 11, 11);
		g.drawOval(rect.getMaxX() - 5, rect.getMaxY() - 5, 11, 11);
		g.drawOval(rect.getMaxX() - 5, rect.getMinY() - 5, 11, 11);
		
		
		
		g.setColor(origColor);
		
	}
	
	public boolean equals(Object other) {
		
		if(other == null)
			return false;
		if(other.getClass() != this.getClass())
			return false;
		ScreenObject soOther = (ScreenObject) other;
		
		IntRect otherRect = soOther.getClickRect();
		IntRect thisRect = this.getClickRect();
		
		if(thisRect.getMinX() != otherRect.getMinX()
				|| thisRect.getMaxX() != otherRect.getMaxX()
				|| thisRect.getMinY() != otherRect.getMinY()
				|| thisRect.getMaxY() != otherRect.getMaxY())
			return false;
		
		return true;
			
		
	}
	
	
}
